﻿/*  NEEDS THESE THINGS:
	_this
	image
	walkInertia.as  (as walk_obj)
	react.as
	loadImage.as
	sendEvent.as
	[swim.as]  (as swim_obj)
	[walkSpeed]
	[RAM.diveDuration]
	[RAM.keys.dive]
	[SPRITE_GRID]
	"terrainChange" event
	"swf\splash.swf" file
	"swf\waterFeet.swf" file  (as waterFeet)
	"swf\diveAnim.swf" file
	
EVENTS:
	dive
	unDive
	diveTimerExpired
*/
// dive ability
isDived = false;


dive_obj = runFunc(function(){
	var waterTerrain = swim_obj.waterTerrain || [2];
	if( RAM.diveDuration === undefined )		RAM.diveDuration = 2;
	var diveAnim_depth = 30;
	var diveAnim_name = "diveAnim";
	
	var diveTimer_max = RAM.diveDuration * 30;		// 2 seconds
	if(!RAM.keys)		RAM.keys = {};
	var dive_obj = {};
	LOOP.addObject( dive_obj, "player" );
	react.to("unload").then = function(){
		LOOP.removeObject( dive_obj, "player" );
	}
	
	var last_diveKeyPressed = null;
	var currentTerrain = -1;
	var diveTimer = 0;
	
	
	react.to("terrainChange").then = function(evt){
		currentTerrain = evt.newTerrain;
	}// when "terrainChange" occurs
	
	
	dive_obj.loop = function(){
		if( isPaused )								return;		// paused = do nothing
		if( !isWaterTerrain(currentTerrain) )		return;		// Can only dive while in water
		
		if( detectDiveButton() ){
			if( !isDived )
			{// if:  not currently dived
				sendEvent("dive");
			}// if:  not currently dived
			else
			{// if:  is dived
				sendEvent("unDive");
			}// if:  is dived
		}// if:  dive button pressed
		
		if(isDived)		runDiveTimer();
		
		//return dive_obj; 	 // nothing needs to directly interact with this object  (yet)
	}// loop()
	
	
	function detectDiveButton(){
		if(RAM.keys.dive === undefined)		RAM.keys.dive = RAM.keys.talk;
		diveKey = RAM.keys.dive || Key.SPACE;
		var diveKeyPressed = Key.isDown( diveKey );
		var output = diveKeyPressed && !last_diveKeyPressed;
		last_diveKeyPressed = diveKeyPressed;
		return output;
	}// detectDiveButton()
	
	
	react.to("dive").then = startDive;
	
	
	react.to("unDive").then = endDive;
	
	
	react.to("diveTimerExpired").then = function(){
		sendEvent("unDive");
	};
	
	
	// exit water = cancel dive
	react.to("terrainChange").then = function(evt){
		if( !isDived )		return;		// if not currently dived,  then do nothing
		var newTerrain = evt.newTerrain;
		var oldTerrain = evt.oldTerrain;
		if( !isWaterTerrain(newTerrain)  &&  isWaterTerrain(oldTerrain) )
		{// if:  just stepped out of water
			//endDive();
			sendEvent("unDive");
		}// if:  just stepped out of water
	}// when "terrainChange" occurs
	
	
	function startDive(){
		if( isDived === true )		return;		// if already dived,  then do nothing
		isDived = true;
		showSplash();
		hideImage();
		showDiveImage();
		hideFoam();
		resetDiveTimer();
		// trigger the "dive" scripts of all sprites on this tile
		SPRITE_GRID.call( tile.x, tile.y, "dive" );
	}// dive()
	
	
	function endDive(){
		if( isDived === false )		return;		// if not currently dived,  then do nothing
		isDived = false;
		showSplash();
		showImage();
		hideDiveImage();
		if( isWaterTerrain(currentTerrain) )	showFoam();
		resetDiveTimer();
		// trigger the "unDive" scripts of all sprites on this tile
		SPRITE_GRID.call( tile.x, tile.y, "unDive" );
	}// endDive()
	
	
	function showSplash(){
		var newDepth = nextDepth(OVERLAY);
		var newName = "splash_"+newDepth;
		var newSplash = OVERLAY.createEmptyMovieClip( newName, newDepth );
		newSplash._x = _x;
		newSplash._y = _y;
		loadImage( "swf\\splash.swf", newSplash );
	}// showSplash()
	
	
	function showDiveImage(){
		var loader = loadImage( "swf\\diveAnim.swf", _this, diveAnim_name, diveAnim_depth, true);
	}// showDiveImage()
	
	
	function hideDiveImage(){
		diveAnim.removeMovieClip();
	}// hideDiveImage()
	
	
	function showImage(){
		image._visible = true;
	}// showImage()
	
	
	function hideImage(){
		image._visible = false;
	}// hideImage()
	
	
	function hideFoam(){
		waterFeet.hasFoam = false;
	}// hideFoam()
	
	
	function showFoam(){
		waterFeet.hasFoam = true;
	}// showFoam()
	
	
	function resetDiveTimer(){
		diveTimer = diveTimer_max;
	}// resetDiveTimer()
	
	
	function runDiveTimer(){
		if(diveTimer > 0)
		{// if:  timer hasn't finished
			diveTimer--;
			if(diveTimer === 0)
			{// if:  timer has just finished
				sendEvent("diveTimerExpired");
			}// if:  timer has just finished
		}// if:  timer hasn't finished
	}// runDiveTimer()
	
	
	function isWaterTerrain( checkTerrain ){
		var output = false;
		for(var t=0; t<waterTerrain.length; t++){
			if(waterTerrain[t] === checkTerrain){
				output = true;
				break;
			}// if:  checkTerrain is one of the valid options, then pass
		}// for:  each waterTerrain
		return output;
	}// isWaterTerrain()
	
	
	dive = startDive;
	unDive = endDive;
});// dive_obj